@Echo off
Rem Autor:	Stefan Hasensperling
Rem Version:	1.0 24.06.2015
Rem			Initial Version

echo.
echo ------------------------------------------------------------------------
echo BatchXpert Backup Restor Utility for Automatic Database Refresh
echo MLogics Chile Ltda.
echo Copyright  MLogics Chile Ltda 2015 
echo. 
echo Backup will be loaded from:
echo \\%Host%\Transfer\%Host%\
echo ------------------------------------------------------------------------
echo.

Rem ################################################################################################################################################################
Rem Checking Command line Parameters and set default values
Rem ------------------------------------------------------------------------
pushd "%~dp0%"

SET Host=%1
SET Visu=%2
SET BC=%3
SET MAT=%4

if [%1] == [] 	Exit
if [%2] == [] 	SET Visu="D:\Kunstmann\Visu\BatchXpert\"
if [%3] == [] 	SET BC=Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=BatchConfig;Data Source=.\GRAPHPIC
if [%4] == []	SET MAT=Integrated Security=SSPI;Persist Security Info=False;Initial Catalog=Material;Data Source=.\GRAPHPIC

Rem ################################################################################################################################################################
Call ShutdownGraphPic
IF ERRORLEVEL 1 GOTO Err6

Rem ################################################################################################################################################################
echo Copy Files from %Host%
echo ------------------------------------------------------------------------

xcopy "\\%Host%\Transfer\%Host%\BatchConfig.bak" "C:\Transfer\%Host%\" /y
IF ERRORLEVEL 1 GOTO Err1

xcopy "\\%Host%\Transfer\%Host%\MaterialConfig.bak" "C:\Transfer\%Host%\" /y
IF ERRORLEVEL 1 GOTO Err2

xcopy "\\%Host%\Transfer\%Host%\Reports" "D:\Kunstmann\Reports" /y /s
IF ERRORLEVEL 1 GOTO Err3

Rem ################################################################################################################################################################
echo Restoring Databases
echo ------------------------------------------------------------------------
echo BatchConfig
"C:\Program Files (x86)\BatchXpert\BatchXpert DB Administration Tool.exe" -r -silent -s="%BC%" -f="C:\Transfer\%Host%\BatchConfig.bak"
IF ERRORLEVEL 1 GOTO Err4

echo MaterialConfig
"C:\Program Files (x86)\BatchXpert\BatchXpert DB Administration Tool.exe" -r -silent -s="%MAT%" -f="C:\Transfer\%Host%\MaterialConfig.bak"
IF ERRORLEVEL 1 GOTO Err5

Rem ################################################################################################################################################################
echo Restoring User Administration
echo ------------------------------------------------------------------------
xcopy "\\%Host%\Transfer\%Host%\GpUsers.XML" "%Visu%" /y
IF ERRORLEVEL 1 GOTO Err7

Rem ################################################################################################################################################################
Call StartupGraphPic
IF ERRORLEVEL 1 GOTO Err8

Rem ################################################################################################################################################################
echo Backup Successful
echo ---------------------------------------------------------------------------------------------------------------------------
:OK

color 02

call ShowMessageBox "The Backup was successfully restored"
EXIT

Rem ################################################################################################################################################################
echo BatchConfig Copy Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Err1

color 04
call ShowErrorBox "Error to copy the BatchConfig backup from %Host%"
EXIT

Rem ################################################################################################################################################################
echo Material Copy Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Err2

color 04
call ShowErrorBox "Error to copy the MaterialConfig backup from %Host%"
EXIT

Rem ################################################################################################################################################################
echo Report Copy Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Err3

color 04
call ShowErrorBox "Error to copy the Reports from %Host%"
EXIT

Rem ################################################################################################################################################################
echo BatchConfig Restore Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Err4

color 04
call ShowErrorBox "Error while restoring the BatchConfig Database"
EXIT

Rem ################################################################################################################################################################
echo Material Restore Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Err5

color 04
call ShowErrorBox  "Error while restoring the MaterialConfig Database"
EXIT

Rem ################################################################################################################################################################
echo BatchXpert Shutdown Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Err6

color 04
call ShowErrorBox "Error while Shutting Down BatchXpert. Please shut down the systm manually and/or restart the computer"
EXIT

Rem ################################################################################################################################################################
echo User Administration 
echo ---------------------------------------------------------------------------------------------------------------------------
:Er7

color 04
call ShowErrorBox "Error while Restoring User Administration"
EXIT

Rem ################################################################################################################################################################
echo BatchXpert Startup Failed
echo ---------------------------------------------------------------------------------------------------------------------------
:Er8

color 04
call ShowErrorBox "Error while Restarting BatchXpert"
EXIT